/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.resource.perks;

import dev.toma.gunsrpg.resource.crate.CountFunctionRegistry;
import dev.toma.gunsrpg.resource.crate.ICountFunction;
import dev.toma.gunsrpg.util.math.WeightedRandom;
import net.minecraft.network.PacketBuffer;

public final class CrystalConfiguration {
    private final Spawns spawns;
    private final Storage storage;

    public CrystalConfiguration(Spawns spawns, Storage storage) {
        this.spawns = spawns;
        this.storage = storage;
    }

    public Spawns getSpawns() {
        return this.spawns;
    }

    public Storage getStorage() {
        return this.storage;
    }

    public void encode(PacketBuffer buffer) {
        this.spawns.encode(buffer);
        this.storage.encode(buffer);
    }

    public static CrystalConfiguration decode(PacketBuffer buffer) {
        return new CrystalConfiguration(Spawns.decode(buffer), Storage.decode(buffer));
    }

    public static final class Storage {
        private final int buffCapacity;
        private final int debuffCapacity;

        public Storage(int buffCapacity, int debuffCapacity) {
            this.buffCapacity = buffCapacity;
            this.debuffCapacity = debuffCapacity;
        }

        public int getBuffCapacity() {
            return this.buffCapacity;
        }

        public int getDebuffCapacity() {
            return this.debuffCapacity;
        }

        public void encode(PacketBuffer buffer) {
            buffer.writeInt(this.buffCapacity);
            buffer.writeInt(this.debuffCapacity);
        }

        public static Storage decode(PacketBuffer buffer) {
            return new Storage(buffer.readInt(), buffer.readInt());
        }
    }

    public static final class Types {
        private final ICountFunction buff;
        private final ICountFunction debuff;

        public Types(ICountFunction buff, ICountFunction debuff) {
            this.buff = buff;
            this.debuff = debuff;
        }

        public int getBuffCount() {
            return this.buff.getCount();
        }

        public int getDebuffCount() {
            return this.debuff.getCount();
        }

        public void encode(PacketBuffer buffer) {
            CountFunctionRegistry.encode(this.buff, buffer);
            CountFunctionRegistry.encode(this.debuff, buffer);
        }

        public static Types decode(PacketBuffer buffer) {
            return new Types((ICountFunction)CountFunctionRegistry.decode(buffer), (ICountFunction)CountFunctionRegistry.decode(buffer));
        }
    }

    public static final class Spawn {
        private final int level;
        private final int weight;

        public Spawn(int level, int weight) {
            this.level = level;
            this.weight = weight;
        }

        public int getLevel() {
            return this.level;
        }

        public int getWeight() {
            return this.weight;
        }

        public void encode(PacketBuffer buffer) {
            buffer.writeInt(this.level);
            buffer.writeInt(this.weight);
        }

        public static Spawn decode(PacketBuffer buffer) {
            return new Spawn(buffer.readInt(), buffer.readInt());
        }
    }

    public static final class Spawns {
        private final WeightedRandom<Spawn> spawns;
        private final Types typeRanges;

        public Spawns(Spawn[] spawns, Types typeRanges) {
            this.spawns = new WeightedRandom<Spawn>(Spawn::getWeight, spawns);
            this.typeRanges = typeRanges;
        }

        public Types getTypeRanges() {
            return this.typeRanges;
        }

        public Spawn getRandomSpawn() {
            return this.spawns.getRandom();
        }

        public void encode(PacketBuffer buffer) {
            Spawn[] spawns = this.spawns.getValues();
            int l = spawns.length;
            buffer.writeInt(l);
            for (Spawn spawn : spawns) {
                spawn.encode(buffer);
            }
            this.typeRanges.encode(buffer);
        }

        public static Spawns decode(PacketBuffer buffer) {
            Spawn[] spawns = new Spawn[buffer.readInt()];
            for (int i = 0; i < spawns.length; ++i) {
                spawns[i] = Spawn.decode(buffer);
            }
            Types types = Types.decode(buffer);
            return new Spawns(spawns, types);
        }
    }
}

